﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Maps.MapControl;



namespace Events
{
    public partial class MainPage : UserControl
    {
        // A collection of key/value pairs containing the event name 
        // and the text block to display the event to.
        Dictionary<string, TextBlock> eventBlocks = new Dictionary<string, TextBlock>();
        // A collection of key/value pairs containing the event name  
        // and the number of times the event fired.
        Dictionary<string, int> eventCount = new Dictionary<string, int>();

        public MainPage()
        {
            InitializeComponent();

            // Fires every animated frame from one location to another.
            MapWithEvents.ViewChangeOnFrame +=
                new EventHandler<MapEventArgs>(MapWithEvents_ViewChangeOnFrame);
            // Fires when the map view location has changed.
            MapWithEvents.TargetViewChanged +=
                new EventHandler<MapEventArgs>(MapWithEvents_TargetViewChanged);
            // Fires when the map view starts to move to its new target view.
            MapWithEvents.ViewChangeStart +=
                new EventHandler<MapEventArgs>(MapWithEvents_ViewChangeStart);
            // Fires when the map view has reached its new target view.
            MapWithEvents.ViewChangeEnd +=
                new EventHandler<MapEventArgs>(MapWithEvents_ViewChangeEnd);
            // Fires when a different mode button on the navigation bar is selected.
            MapWithEvents.ModeChanged +=
                new EventHandler<MapEventArgs>(MapWithEvents_ModeChanged);
            // Fires when the mouse is double clicked
            MapWithEvents.MouseDoubleClick +=
                new EventHandler<MapMouseEventArgs>(MapWithEvents_MouseDoubleClick);
            // Fires when the mouse pans the map
            MapWithEvents.MousePan +=
                new EventHandler<MapMouseDragEventArgs>(MapWithEvents_MousePan);
            // Fires when a drag box is created, if implemented
            // (e.g. hold CTRL and pan mouse)
            MapWithEvents.MouseDragBox +=
                new EventHandler<MapMouseDragEventArgs>(MapWithEvents_MouseDragBox);

            // Fires when the mouse is clicked, toggling between the Road, 
            // Aerial, and AerialWithLabels map modes.
            MapWithEvents.MouseClick +=
                new EventHandler<MapMouseEventArgs>(MapWithEvents_MouseClick);
        }

        void MapWithEvents_MouseClick(object sender, MapMouseEventArgs e)
        {
            // Updates the count of single mouse clicks.
            ShowEvent("MapWithEvents_MouseClick");

            // Toggles between map modes.
            switch (eventCount["MapWithEvents_MouseClick"] % 2)
            {
                case 0:
                    MapWithEvents.Mode = new RoadMode();
                    break;
                case 1:
                    MapWithEvents.Mode = new AerialMode();
                    break;
            }

            // The event has been handled by this custom handler, disabling
            // the default single-click behavior.
            e.Handled = true;
        }

        void MapWithEvents_MouseDragBox(object sender, MapMouseDragEventArgs e)
        {
            // Updates the count of mouse drag boxes created.
            ShowEvent("MapWithEvents_MouseDragBox");
        }

        void MapWithEvents_MousePan(object sender, MapMouseDragEventArgs e)
        {
            // Updates the count of mouse pans.
            ShowEvent("MapWithEvents_MousePan");
        }

        void MapWithEvents_MouseDoubleClick(object sender, MapMouseEventArgs e)
        {
            // Updates the count of mouse double clicks.
            ShowEvent("MapWithEvents_MouseDoubleClick");
        }

        void MapWithEvents_ViewChangeEnd(object sender, MapEventArgs e)
        {
            //Updates the number of times the map view has changed.
            ShowEvent("ViewChangeEnd");
        }

        void MapWithEvents_ViewChangeStart(object sender, MapEventArgs e)
        {
            //Updates the number of times the map view started changing.
            ShowEvent("ViewChangeStart");
        }

        void MapWithEvents_ViewChangeOnFrame(object sender, MapEventArgs e)
        {
            // Updates the number of times a map view has changed 
            // during an animation from one location to another.
            ShowEvent("ViewChangeOnFrame");
        }
        void MapWithEvents_TargetViewChanged(object sender, MapEventArgs e)
        {
            // Updates the number of map view changes that occured during
            // a zoom or pan.
            ShowEvent("TargetViewChange");
        }

        void MapWithEvents_ModeChanged(object sender, MapEventArgs e)
        {
            // Updates the number of times the map mode changed.
            ShowEvent("ModeChanged");
        }

        void ShowEvent(string eventName)
        {
            // Updates the display box showing the number of times 
            // the wired events occured.
            if (!eventBlocks.ContainsKey(eventName))
            {
                TextBlock tb = new TextBlock();
                tb.Foreground = new SolidColorBrush(
                    Color.FromArgb(255, 128, 255, 128));
                tb.Margin = new Thickness(5);
                eventBlocks.Add(eventName, tb);
                eventCount.Add(eventName, 0);
                eventsPanel.Children.Add(tb);
            }

            eventCount[eventName]++;
            eventBlocks[eventName].Text = String.Format(
                "{0}: [{1} times] {2} (HH:mm:ss:ffff)",
                eventName, eventCount[eventName].ToString(), DateTime.Now.ToString());
        }
    }
}
